---
type: constant
tags:
  - "#layer/translation"
  - "#status/stable"
  - "#function/definition"
polarity: P-
aliases:
  - Asymmetric Stabilization Ratio
---

# φ — Asymmetric Stabilization Ratio (constant)

> Encodes the bias toward one attractor over another; determines if form tips toward propagation or absorption.

---

## Definition (concept)

- Symbol: φ
- Conceptual name: Asymmetric Stabilization Ratio
- Conceptual value: conceptual (math instance carries number)
- Definition: positive root of $x^2 = x + 1$; limit of consecutive Fibonacci ratios (math instance)

---

## Derivation from Base Constants

φ emerges directly from **A2 — Asymmetry (axiom)**:

**From A2:** Difference has inherent directionality - not all positions are equivalent
- This asymmetry creates **bias patterns** where one outcome is favored over another
- φ (golden ratio) represents the optimal asymmetric split: $\frac{1+\sqrt{5}}{2} \approx 1.618$
- **Mathematical foundation:** $φ^2 = φ + 1$ - the unique ratio that is self-reinforcing

**Axiom Foundation:** A2's directional bias naturally leads to asymmetric stabilization ratios like φ.

---

## Dual‑register mapping (concept)

Map the constant into both registers and show the bridge explicitly.

### Technical (network/computational)

| Constant concept | Network construct (Target) | Interface/API example |
|-----------------|---------------------------|----------------------|
| Asymmetry | Bias coefficient | `BiasRatio` |
| Partition | Resource split | `AsymmetricSplitter` |
| Attractor | Stability point | `StableState` |

### Humane (biological/relational)

| Constant concept | Humane construct (Target) | Example |
|-----------------|---------------------------|---------|
| Asymmetry | Natural preference | When one path feels "right" |
| Partition | Fair sharing | The art of giving and keeping |
| Attractor | Natural tendency | Where things want to settle |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Bias ratio | Natural lean | How difference chooses sides |
| Split point | Balance point | Where whole meets part |
| Stable state | Comfort zone | Natural resting place |

---

## Domain Mapping

Brief examples across domains showing both technical and humane angles:

| Domain | Technical manifestation | Humane manifestation |
|--------|------------------------|---------------------|
| Physics | Energy partition | Natural balance |
| Chemistry | Reaction bias | Preferred pathway |
| Biology | Growth proportion | Natural form |
| Social | Network preference | Relationship dynamics |
| Economy | Resource allocation | Value distribution |
| Politics | Power balance | Natural alignment |
| Networks | Traffic split | Flow preference |
| Cognition | Attention bias | Natural focus |

---

## Anchor role

- Normalizes asymmetric partitioning and self‑similar structuring
- Guides bias in recursive transitions (propagation vs absorption)

---

## Scope & invariance

- Dimensionless ratio applicable across domains
- Manifests in both static (proportion) and dynamic (preference) contexts

---

## Interplay with SVA (if relevant)

- ∇S: guides structural partitioning bias
- λV: shapes resonance preference in field
- ψA: influences phase alignment tendency

---

## Instances (domain bindings)

- Math: [[φ — Golden Ratio (constant)|φ — Golden Ratio]]

---

## See Also

- [[π — Closure Geometry Ratio (constant)]]
- [[e — Natural Transformation Rate (constant)]]
- [[ε — Difference Resolution Quantum (constant)]]
- [[c — Difference Propagation Limit (constant)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included